﻿//////////////////////////////////////////////
// BoundingBoxWrapper.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkScripts
{
	class Environment ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../../Dll/DllDefines.h"

// nkScripts
#include <NilkinsScripts/Environments/Functions/Function.h>

/// Class ------------------------------------

namespace nkAstraeus::nkGraphicsWrap
{
	class DLL_ASTRAEUS_EXPORT BoundingBoxWrapper final
	{
		public :

			// Environment update
			static void updateEnvironment (nkScripts::Environment* env) ;

			// Callbacks
			// Constructor, destructor
			static void* constructor (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue newCube (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue newBox (const nkScripts::DataStack& stack) ;
			static void destructor (void* toDestroy) ;
			// Getters
			static nkScripts::OutputValue getCenter (const nkScripts::DataStack& stack) ;
			// Checks
			static nkScripts::OutputValue checkAgainst (const nkScripts::DataStack& stack) ;
	} ;
}